//  Listing 8.13. Hermetyzacja powoduje odizolowanie macierzy 
// do tymczasowego przechowywania danych store[ ]
// hermetyzacja z ukrywaniem danych

#include <iostream> 
#include <cstring>
using namespace std;

struct Store 
{
  char a[81]; 		// tablica do tymczasowego przechowywania
  int idx; } ; 		// indeks wskazuje pierwsze wolne miejsce
  void initStore (Store &s)
   { s.idx = 0; } 			// inicjujemy pusty skad
  bool isEmpty (const Store& s)
   { return (s.idx == 0); } 		// sprawdzamy, czy skad jest pusty
  void saveSymbol (Store &s, char x)
   { s.a[s.idx++] = x; } 		// zapamitujemy znak w skadzie
  char getLast(Store &s)
   { return s.a[--s.idx]; } 		// wracamy do ostatniego zapamitanego znaku
  bool isLeft (char c)
   { return (c=='(' || c=='['); } 	// czy to lewy nawias?
  bool isRight (char c)
   { return (c==')' || c==']'); } 	// czy to prawy nawias?
  bool symbolsMatch (char c, char sym)
   { return (sym=='('&&c==')')||(sym=='['&&c==']');} 	// czy nawiasy pasuj?
  bool checkParen (char buffer[]) 	// wyraone za pomoc parametru
   { Store store; 			// tablica jest hermetyzowana (odizolowana)
     char c, sym; 
     int i; 
     bool valid;
	i = 0; 
	initStore(store);  valid = true; 	// inicjujemy dane
     while (buffer[i] != '\0' && valid) 	// koniec danych czy bd?
     { c = buffer[i]; 				// pobierz nastpny znak - symbol
       if (isLeft(c)) 				// czy to lewy nawias?
       { saveSymbol(store,c); } 		// jeli tak - zapamitaj ten nawias
       else if (isRight(c)) 			// czy to prawy nawias?
       if (!isEmpty(store)) 			// czy jest oczekujcy w pamici lewy nawias "do pary"?
       { sym = getLast(store); 			// pobierz ostatni znak
       if (!symbolsMatch(c,sym)) 		// jeli te nawiasy nie pasuj do siebie,
       valid = false; 				// to oznacza bd formalny w wyraeniu
    } 
    else
    valid = false; 				// jeli nie ma oczekujcego lewego nawiasu do dopasowania, 
    i++; } 					// przejd do nastpnego znaku
    if (store.idx>0) valid=false; 		// bd - niedopasowane lewe nawiasy
    return valid; } 				// zwr rezultat analizy

void checkParenTest(char expression[])
{ 
  cout << "Wyraenie " << expression << endl; 	// drukuj wyraenie
  if (checkParen(expression))                   // dokonaj walidacji wyraenia
  cout << "jest prawidowe\n"; 			// drukuj rezultat walidacji
  else
  cout << "jest nieprawidowe\n"; 
} 

int main()
{ 
  cout << endl << endl;            		// bd w wyraeniu
  checkParenTest("a=(x[i]+5)*y;"); 		// pierwszy test - OK
  checkParenTest("a=(x[i)+5]*y;"); 		// drugi test - bd
  checkParenTest("a=(x(i]+5]*y;"); 		// trzeci test - bd
  cout << endl << endl;
  return 0;
}
